package client;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import common.*;

public class View implements IView {

	private JFrame frame;
	public JComboBox comboBox;
	public JTextArea textArea;

	@Override
	public void initalizeAndDisplayView(final Presenter presenter) {
		frame = new JFrame("Nifty Search Application");
		frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		JPanel pane = new JPanel();
		comboBox = new JComboBox(presenter.getSearchOptionSelectionStrings());
		JButton searchButton = new JButton("Search");
		textArea = new JTextArea();

		searchButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent actionEvent) {
				presenter.searchButtonPressed();
			}
		});

		pane.add(comboBox);
		pane.add(searchButton);
		pane.add(textArea);

		frame.add(pane, BorderLayout.CENTER);
		frame.pack();
		frame.setVisible(true);
	}

	@Override
	public int getSelectedSearchIndex() {
		return comboBox.getSelectedIndex();
	}

	@Override
	public void setDisplayText(String displayText) {
		textArea.setText(displayText);
		frame.pack();
	}

}
